rm(list=ls())
library(cmdstanr)
library(bayesplot)
library(posterior)
library(mcmcplots)
library(magrittr)
library(multipanelfigure)
library(data.table)
library(tidylog)
library(tidyverse)

setwd("")



# As before, say we had set up an experiment in which we applied a continuous treatment (x1, year) ranging 
# in magnitude from 0 to 16 to a total of 16 sampling units (n=16), and a dummy variable (x2) 
# indicating their sex (0: female, 1: male), are and then measured a 
# response (y) from each unit. 


data <- list(
  n=16,
  x1 = c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16),
  x2 = c(0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1),
  y=c(35.70,35.85,43.29,34.35,33.15,39.58,31.80,21.67,23.07,22.77,29.62,23.80,22.50,19.55,14.72,24.93)
  )



example4 <- cmdstan_model("STAN/example4.stan")


initial_values <- list(
  list(beta0 = mean(data$y), beta = rep(0,2), sigma = sd(data$y)),
  list(beta0 = mean(data$y)+1, beta = rep(1,2), sigma = sd(data$y)),
  list(beta0 = mean(data$y)+1, beta = rep(-1,2), sigma = sd(data$y))
  )

example4_fit <- example4$sample(data=data,
                                seed=123,
                                iter_warmup=2000,
                                iter_sampling=2000,
                                chains = 3,
                                parallel_chains=3,
                               save_warmup = TRUE,
                               thin=1,
                               max_treedepth=15,
                               init=initial_values)
example4_fit$summary()

post_draws <- example4_fit$draws() # this is how you store the chain from Stan
#figure2 <- multi_panel_figure(columns = 3, rows = 3, panel_label_type = "upper-roman")
figure1 <- multi_panel_figure(columns = 6, rows = 10, panel_label_type = "upper-roman")
figure1 %<>%
  fill_panel(mcmc_trace(post_draws,pars=c('beta0','beta[1]','beta[2]')), column = 1:6, row = 1:2) %<>%
  fill_panel(mcmc_dens_overlay(post_draws,pars=c('beta0','beta[1]','beta[2]')), column = 1:6, row = 3:4) %<>%
  fill_panel(mcmc_acf_bar(post_draws,pars='beta0'), column = 1:2, row = 5:10) %>%
  fill_panel(mcmc_acf_bar(post_draws,pars='beta[1]'), column = 3:4, row = 5:10) %>%
  fill_panel(mcmc_acf_bar(post_draws,pars='beta[2]'), column = 5:6, row = 5:10) 
figure1






posterior_sample <- data.frame(example4_fit$draws(format = "matrix",inc_warmup = FALSE))

sigma <- mean(posterior_sample[,'sigma'])
log_lik_theta_hat <- rep(0,16)
for(i in 1:16){
  mu <- mean(posterior_sample[,paste('mu.',i,'.',sep='')])
    log_lik_theta_hat[i] <- dnorm(y[i],mean=mu,sd=sigma,log=TRUE)
}





total_log_lik_theta_hat <- sum(log_lik_theta_hat)
mean_log_lik_theta <- mean(posterior_sample[,'log_lik'])
#getwd()
pD <- 2 * (total_log_lik_theta_hat - mean_log_lik_theta)
DIC <- (-2 * total_log_lik_theta_hat) + (2*pD)
DIC3 <- (-2 * mean_log_lik_theta) + (pD)


